/*
 * Decompiled with CFR 0.152.
 */
package org.figuramc.figura.gui.widgets;

import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import org.figuramc.figura.gui.widgets.ScrollBarWidget;
import org.figuramc.figura.utils.FiguraIdentifier;
import org.figuramc.figura.utils.ui.UIHelper;

public class SliderWidget
extends ScrollBarWidget {
    public static final ResourceLocation SLIDER_TEXTURE = new FiguraIdentifier("textures/gui/slider.png");
    protected final int headHeight = 11;
    protected final int headWidth = 11;
    protected final boolean showSteps;
    private int max;
    private double stepSize;
    private double steppedPos;

    public SliderWidget(int x, int y, int width, int height, double initialValue, int maxValue, boolean showSteps) {
        super(x, y, width, height, initialValue);
        this.vertical = false;
        this.showSteps = showSteps;
        this.steppedPos = initialValue;
        this.setMax(maxValue);
    }

    @Override
    public boolean mouseScrolled(double mouseX, double mouseY, double amount, double d) {
        if (!this.isActive()) {
            return false;
        }
        this.scroll(this.stepSize * Math.signum(-amount - d) * ((double)(this.getWidth() - 11) + 2.0));
        return true;
    }

    @Override
    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (!this.isActive()) {
            return false;
        }
        if (keyCode > 261 && keyCode < 266) {
            this.scroll(this.stepSize * (double)(keyCode % 2 == 0 ? 1 : -1) * (double)Math.max(modifiers * 10, 1) * ((double)(this.getWidth() - 11) + 2.0));
            return true;
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }

    @Override
    protected void scroll(double amount) {
        super.scroll(amount);
        this.steppedPos = this.getClosestStep();
    }

    private double getClosestStep() {
        double distanceHigh;
        double lowest = this.scrollPrecise - this.scrollPrecise % this.stepSize;
        double highest = lowest + this.stepSize;
        double distanceLow = Math.abs(lowest - this.scrollPrecise);
        return distanceLow < (distanceHigh = Math.abs(highest - this.scrollPrecise)) ? lowest : highest;
    }

    @Override
    public void renderWidget(GuiGraphics gui, int mouseX, int mouseY, float delta) {
        this.isHovered = this.isMouseOver(mouseX, mouseY);
        UIHelper.enableBlend();
        int x = this.getX();
        int y = this.getY();
        int width = this.getWidth();
        gui.blit(SLIDER_TEXTURE, x, y + 3, width, 5, this.isScrolling ? 10.0f : 0.0f, 0.0f, 5, 5, 33, 16);
        if (this.showSteps) {
            for (int i = 0; i < this.max; ++i) {
                gui.blit(SLIDER_TEXTURE, (int)Math.floor((double)(x + 3) + this.stepSize * (double)i * (double)(width - 11)), y + 3, 5, 5, this.isScrolling ? 15.0f : 5.0f, 0.0f, 5, 5, 33, 16);
            }
        }
        this.lerpPos(delta);
        gui.blit(SLIDER_TEXTURE, (int)((long)x + Math.round(Mth.lerp((double)this.scrollPos, (double)0.0, (double)(width - 11)))), y, this.isActive() ? (float)(this.isHoveredOrFocused() || this.isScrolling ? 22 : 11) : 0.0f, 5.0f, 11, 11, 33, 16);
    }

    @Override
    public double getScrollProgress() {
        return this.steppedPos;
    }

    @Override
    public void setScrollProgress(double amount, boolean force) {
        this.steppedPos = force ? amount : Mth.clamp((double)amount, (double)0.0, (double)1.0);
        super.setScrollProgress(amount, force);
    }

    public int getMax() {
        return this.max;
    }

    public void setMax(int maxValue) {
        this.max = maxValue;
        this.stepSize = 1.0 / (double)(maxValue - 1);
    }

    public int getIntValue() {
        return (int)Math.round(this.getScrollProgress() * (double)(this.getMax() - 1));
    }
}

